-- ************************************
-- VX_sp_UpdateCallBackRules
-- ************************************
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_sp_UpdateCallBackRules]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[VX_sp_UpdateCallBackRules]
GO
CREATE PROCEDURE [dbo].[VX_sp_UpdateCallBackRules]
@NewRules xml  
AS  
BEGIN  
 SET NOCOUNT ON;  
SELECT  
   colx.value('Id[1]','int') as Id   
  ,colx.value('RulNumber[1]','int') as RulNumber  
  ,colx.value('RulResult[1]','varchar(2)') as RulResult  
  ,colx.value('RulCount[1]','int') as RulCount  
  ,colx.value('RulConsecutive[1]','bit') as RulConsecutive  
  ,colx.value('RulCallback[1]','bit') as RulCallback  
  ,colx.value('RulInterviewer[1]','varchar(10)') as RulInterviewer  
  ,colx.value('RulDelay[1]','int') as RulDelay  
  ,colx.value('RulUnit[1]','int') as RulUnit  
  ,colx.value('RulPriority[1]','int') as RulPriority  
  ,colx.value('RulPriorityType[1]','int') as RulPriorityType  
  ,colx.value('RulWaveInc[1]','bit')as RulWaveInc  
  ,colx.value('projectId[1]','int') as projectid  
  ,colx.value('modifiedBy[1]','int') as modifiedBy  
  ,colx.value('xs:dateTime(modified[1])','datetime') as modified  
  ,colx.value('SynchResult[1]','int') as SynchResult  
  ,colx.value('DialingMode[1]','int') as DialingMode  
  ,colx.value('RestrictionOverride[1]','bit') as RestrictionOverride  
  ,colx.value('UploadToA4S[1]','bit') as UploadToA4S  
  ,colx.value('PhoneCyclingBehavior[1]','int') as PhoneCyclingBehavior
 INTO #TMP FROM @NewRules.nodes('NewDataSet/CallBackRule') AS Tabx(Colx)  
 update Rules   
 set deleted = 1   
 from (  
  select Id,RulResult,RulCount,RulConsecutive,RulCallback,  
   isnull(RulInterviewer,'') as RulInterviewer,RulDelay,RulUnit,RulPriority,RulPriorityType,RulWaveInc,projectId,SynchResult,DialingMode,RestrictionOverride,UploadToA4S,PhoneCyclingBehavior
  from Rules where deleted = 0  
  except  
  select Id,RulResult,RulCount,RulConsecutive,RulCallback,  
   isnull(RulInterviewer,'') as RulInterviewer,RulDelay,RulUnit,nullif(RulPriority,0) as RulPriority,RulPriorityType as RulPriorityType,RulWaveInc,projectId,SynchResult,DialingMode,RestrictionOverride,UploadToA4S,PhoneCyclingBehavior
  from #TMP   
  )b  
 where deleted = 0  and Rules.Id = b.Id  
  update rules set rules.modifiedBy = #TMP.modifiedBy ,rules.modified = #TMP.modified from #TMP  
  where rules.deleted = 1 and #TMP.Id = rules.Id    

 insert into Rules (RulNumber,RulResult,RulCount,RulConsecutive,RulCallback,  
  RulInterviewer,RulDelay,RulUnit,RulPriority,RulPriorityType,RulWaveInc,projectId,modifiedBy,modified,SynchResult,DialingMode,RestrictionOverride,UploadToA4S,PhoneCyclingBehavior)  
   select #TMP.RulNumber,#TMP.RulResult,#TMP.RulCount,#TMP.RulConsecutive,#TMP.RulCallback,  
  isnull(#TMP.RulInterviewer,'') as RulInterviewer,#TMP.RulDelay,#TMP.RulUnit,#TMP.RulPriority,#TMP.RulPriorityType,#TMP.RulWaveInc,#TMP.projectId,#TMP.modifiedBy,#TMP.modified,#TMP.SynchResult,#TMP.DialingMode
  ,#TMP.RestrictionOverride,IsNull(#TMP.UploadToA4S, 0),ISNULL(#TMP.PhoneCyclingBehavior,0)
 from #TMP   
 WHERE NOT EXISTS (SELECT * FROM Rules WHERE deleted=0 AND RulResult=#TMP.RulResult AND RulCount=#TMP.RulCount)  
 DROP TABLE #TMP  
END  

